<?php

namespace App\Jobs;

use App\Models\ApiLog;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdateApiLogJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(
        public string $uuid,
        public int $statusCode,
        public array $responseHeaders = [],
        public string|array $responseBody = '',
    )
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $log = ApiLog::query()->where('uuid', $this->uuid)->first();
        $log?->update([
            'responseStatusCode' => $this->statusCode,
            'responseHeaders' => $this->responseHeaders,
            'responseBody' => is_array($this->responseBody) ? json_encode($this->responseBody) : $this->responseBody,
        ]);
    }
}
