<?php

namespace App\Jobs\Shopify;

use App\Models\IntegrationInstance;
use App\Repositories\Shopify\ShopifyWebhookEventRepository;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\Middleware\WithoutOverlapping;
use Illuminate\Queue\SerializesModels;
use Throwable;

class ShopifyPurgeOldWebhooksJob implements ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected IntegrationInstance|int $integrationInstance)
    {
        $this->integrationInstance = $integrationInstance instanceof IntegrationInstance ? $integrationInstance : IntegrationInstance::query()->findOrFail($integrationInstance);
    }

    public function middleware(): array
    {
        return [(new WithoutOverlapping('PurgeOldWebhooksJob'))->releaseAfter(5)->expireAfter(120)];
    }

    /**
     * Execute the job.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        /*
         * Process webhook payloads
         */
        app()->make(ShopifyWebhookEventRepository::class)->purgeOld($this->integrationInstance);
    }
}
