<?php

namespace App\Jobs\Shopify;

use App\Models\SalesOrder;
use App\Models\Shopify\ShopifyOrder;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ShopifyMapSalesOrderLinesAfterCreateSkuProductsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(
        private int $salesOrderId,
        private int $shopifyProductId
    ) {
        $this->onQueue('salesOrderProcessing');
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        ShopifyMapSalesOrderLines::handleAfterMapLines(
            SalesOrder::findOrFail($this->salesOrderId),
            ShopifyOrder::findOrFail($this->shopifyProductId),
            null,
            false
        );
    }
}
