<?php

namespace App\Jobs\Shopify;

use App\Integrations\Shopify;
use App\Models\IntegrationInstance;
use App\Models\Shopify\ShopifyShippingService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ShopifyGetShippingServices implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * @var IntegrationInstance
     */
    protected $integrationInstance;

    /**
     * The processing job summary.
     *
     * @var array
     */
    protected $summary = ['Carriers Count' => 0, 'Services Count' => 0];

    /**
     * Create a new job instance.
     */
    public function __construct(IntegrationInstance $integrationInstance)
    {
        $this->integrationInstance = $integrationInstance;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        set_time_limit(0);

        $shopify = new Shopify($this->integrationInstance);

        $existsServices = [];
        foreach ($shopify->getShippingServices()['carrier_services'] ?? [] as $service) {
            // store shipping services
            $shippingService = ShopifyShippingService::with([])->firstOrCreate(
                [
                    'shopify_id' => $service['id'],
                    'integration_instance_id' => $this->integrationInstance->id,
                ],
                array_merge($service, ['code' => $service['shopify_id'], 'domestic' => true])
            );

            $existsServices[] = $shippingService->_id;

            // SUMMARY
            $this->summary['Services Count'] += 1;
        }

        // soft delete services that not retrieve from ShipStation
        ShopifyShippingService::query()
            ->where('integration_instance_id', $this->integrationInstance->id)
            ->whereNotIn('_id', $existsServices)
            ->delete();

        // for logging
        $this->options = ['Integration Instance' => $this->integrationInstance->name.' ('.$this->integrationInstance->id.') '];
    }
}
