<?php

namespace App\Jobs\Shopify;

use App\Models\IntegrationInstance;
use App\Models\Shopify\ShopifyOrder;
use App\Models\Shopify\ShopifyProduct;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ShopifyCacheListingHasOrders implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        /*
         * This could have major performance implications so disabling for now
         */
        return; // disabling
        $integrationInstances = IntegrationInstance::with([])->shopify()->pluck('id');

        $query = ShopifyProduct::with([]);

        $query->whereIn('integration_instance_id', $integrationInstances)
            ->select('_id', 'id', 'integration_instance_id')
            ->chunk(100, function ($listings) {
                /** @var ShopifyProduct $listing */
                foreach ($listings as $listing) {
                    $listing->has_orders = ShopifyOrder::with([])
                        ->where('integration_instance_id', $listing['integration_instance_id'])
                        ->where('line_items.variant_id', $listing['id'])
                        ->exists();
                    $listing->save();
                }
            });
    }
}
