<?php

namespace App\Jobs\Shopify;

use App\Enums\Shopify\ShopifyBulkOperationTypeEnum;
use App\Models\IntegrationInstance;
use App\Services\Shopify\ShopifyProductManager;
use Exception;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

/**
 * Should be unique since only one allowed to run at a time on Shopify side
 */
class CreateShopifyGetProductVariantsBulkOperationJob implements ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels, ShopifyBulkOperationTrait;

    public int $tries = 0;

    public int $uniqueFor = 60 * 5;

    public function uniqueId(): string
    {
        return 'shopify-bulk-get-product-variants-'.$this->integrationInstance->id;
    }

    public function __construct(protected IntegrationInstance|int $integrationInstance)
    {
        $this->integrationInstance = $integrationInstance instanceof IntegrationInstance ? $integrationInstance : IntegrationInstance::query()->findOrFail($integrationInstance);
    }

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        if (config('app.env') != 'production') {
            return;
        }

        $response = (new ShopifyProductManager($this->integrationInstance))->getBulkProductVariants();

        $this->handleBulkOperationResponse($response, ShopifyBulkOperationTypeEnum::OPERATION_TYPE_GET_PRODUCT_VARIANTS);
    }
}
