<?php

namespace App\Jobs;

use App\Enums\FinancialAlertNotificationConditionEnum;
use App\Managers\FinancialAlertManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendFinancialAlertSummaryJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(private readonly FinancialAlertNotificationConditionEnum $condition)
    {
    }

    public function handle(): void
    {
        app(FinancialAlertManager::class)->sendSummaryAlertNotification($this->condition);
    }
}
