<?php

namespace App\Jobs;

use Facades\App\Services\InventoryManagement\Actions\ReleaseBackorderQueues;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ReleaseBackorderQueuesJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected array $productIds;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(array $productIds)
    {
        $this->productIds = $productIds;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        ReleaseBackorderQueues::release($this->productIds);
    }
}
