<?php

namespace App\Jobs;

use App\Exceptions\PurchaseOrder\NotOpenPurchaseOrderException;
use App\Services\PurchaseOrder\ShipmentManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ReceiveLargePurchaseOrder implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected array $receiptLines = [];

    protected array $payload = [];

    protected ?int $userId;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
    }

    public static function withLines(array $lines, array $payload, ?int $userId): self
    {
        $job = new self();
        $job->receiptLines = $lines;
        $job->payload = $payload;
        $job->userId = $userId;

        return $job;
    }

    /**
     * Execute the job.
     *
     * @throws NotOpenPurchaseOrderException
     */
    public function handle(): void
    {
        set_time_limit(0);

        $manager = new ShipmentManager();
        $manager->receiveLines(
            $this->receiptLines,
            $this->payload,
            true,
            null,
            $this->userId
        );
    }
}
