<?php

namespace App\Jobs;

use App\Models\FifoLayer;
use App\Services\InventoryManagement\InventoryManager;
use App\Services\InventoryManagement\PositiveInventoryEvent;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessNewInventory implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(public FifoLayer $fifoLayer, public PositiveInventoryEvent $event, public bool $autoApplyStock = true)
    {
    }

    /**
     * Execute the job.
     *
     * @throws \Exception
     */
    public function handle(): void
    {
        set_time_limit(0);

        $manager = InventoryManager::with(
            $this->fifoLayer->warehouse_id,
            $this->fifoLayer->product
        );

        if ($this->autoApplyStock) {
            $manager->onStockAvailable($this->fifoLayer, $this->event, $this->fifoLayer->available_quantity);
        }
    }
}
