<?php

namespace App\Jobs;

use App\Managers\FinancialAlertManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;

class ProcessFinancialAlertsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private ?Collection $salesOrderLines;

    public function __construct(?Collection $salesOrderLines = null)
    {
        $this->salesOrderLines = $salesOrderLines;
        $this->onQueue('financials');
    }

    public function handle(): void
    {
        app(FinancialAlertManager::class)->createFinancialAlerts($this->salesOrderLines);
    }
}
