<?php

namespace App\Jobs\Middleware;

use App\Enums\IntegrationInstanceSyncStatusEnum;
use Exception;

class ActiveIntegrationInstanceStatusMiddleware
{
    /**
     * Process the queued job.
     *
     * @param  mixed  $job
     * @param  callable  $next
     * @return mixed
     */
    public function handle($job, $next)
    {
        if ($job?->integrationInstance?->sync_status === IntegrationInstanceSyncStatusEnum::INACTIVE) {
            throw new Exception('Integration instance sync_status is Inactive', 1);
        }

        return $next($job);
    }
}
