<?php

namespace App\Jobs;

use App\Data\SalesOrderLineMappingData;
use App\Services\SalesOrder\SalesOrderManager;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\DataCollection;
use Throwable;

class MapSalesOrderLinesToSalesChannelProductsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(#[DataCollectionOf(SalesOrderLineMappingData::class)] private readonly DataCollection $salesOrderLineCollection)
    {
        $this->queue = 'salesOrderProcessing';
    }

    /**
     * @throws Exception
     * @throws Throwable
     */
    public function handle(): void
    {
        app(SalesOrderManager::class)->mapSalesOrderLinesToSalesChannelProducts($this->salesOrderLineCollection);
    }
}
