<?php

namespace App\Jobs;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Managers\ProductListingManager;
use App\Models\IntegrationInstance;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;

class MapSalesOrderLinesJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        private readonly Collection $mappings,
        private readonly string $salesChannelProductClass,
        private readonly IntegrationInstanceInterface|IntegrationInstance $integrationInstance)
    {
        $this->queue = 'salesOrderProcessing';
    }

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        (new ProductListingManager())->mapListings($this->mappings, app($this->salesChannelProductClass), $this->integrationInstance);
    }
}
