<?php

namespace App\Jobs\Magento;

use App\Integrations\Magento;
use App\Models\IntegrationInstance;
use App\Models\Magento\ProductAttribute;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class GetProductAttributesJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected IntegrationInstance $integrationInstance, protected array $options = [])
    {
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $magento = new Magento($this->integrationInstance);

        foreach ($magento->getProductAttributes(['pageSize' => 300]) as $response) {
            array_map(fn ($productAttribute) => $this->handleProductAttribute($productAttribute), $response['items']);
        }
    }

    private function handleProductAttribute(array $productAttribute)
    {
        ProductAttribute::query()->updateOrCreate(
            ['integration_instance_id' => $this->integrationInstance->id, 'attribute_id' => $productAttribute['attribute_id']],
            ['json_object' => $productAttribute]
        );
    }
}
