<?php

namespace App\Jobs;

use App\Repositories\ProductRepository;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class InvalidateDailyAverageConsumptionForProductsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected array $productIds;

    protected ProductRepository $productRepository;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(array $productIds = [])
    {
        $this->productIds = $productIds;
        $this->productRepository = app(ProductRepository::class);
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $this->productRepository->invalidateDailyAverageConsumptionCache($this->productIds);
    }
}
