<?php

namespace App\Jobs;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelIntegrationInstance;
use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelProductManager;
use App\Data\SalesChannelProductImportMappingData;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Throwable;

class ImportSalesChannelProductMappingsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        protected readonly SalesChannelProductImportMappingData $data,
        protected readonly AbstractSalesChannelProductManager $manager
    )
    {
    }

    /**
     * @throws Throwable
     */
    public function handle(): void
    {
        $this->manager->importMappings($this->data);
    }
}
