<?php

namespace App\Jobs;

use App\Http\Controllers\Traits\OrdersExports;
use App\Models\PurchaseOrder;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class GeneratePurchaseOrderPicklist implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, OrdersExports, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(protected PurchaseOrder $purchaseOrder)
    {
    }

    /**
     * Execute the job.
     */
    public function handle(): string
    {
        set_time_limit(0);

        return $this->generateJasperReport(
            $this->purchaseOrder,
            'SKU_Purchase_Order_Picklist.jrxml',
            "{$this->purchaseOrder->purchase_order_number}_Picklist",
            'picklist'
        );
    }
}
