<?php

namespace App\Jobs;

use App\Models\Product;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Redis;
use Throwable;

class GenerateCacheDailyAverageConsumptionForProductsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected array $productIds;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(array $productIds = [])
    {
        $this->onQueue('products');
        $this->productIds = $productIds;
    }

    /**
     * Execute the job.
     * @throws Throwable
     */
    public function handle(): void
    {
        if (empty($this->productIds)) {
            $productIds = Redis::connection('cache')->smembers(Product::INVALID_DAILY_AVERAGE_CONSUMPTION_KEY);
        } else {
            $productIds = $this->productIds;
        }

        $jobs = [];
        foreach (array_chunk($productIds, 1000) as $chunk) {
            $jobs[] = new CacheDailyAverageConsumptionForProductsJob($chunk);
        }

        if (!empty($jobs)) {
            Bus::batch($jobs)->name('Cache Daily Average Consumption')->dispatch();
        }
    }
}
