<?php

namespace App\Jobs;

use App\Models\User;
use App\Notifications\FulfillSalesOrdersNotification;
use App\Services\SalesOrder\BulkFulfillSalesOrdersService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Http\Request;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class FulfillSalesOrdersJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * @var array
     */
    protected $requestData;

    /**
     * @var User
     */
    protected $user;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(Request $request, User $user)
    {
        $this->requestData = $request->all();
        $this->user = $user;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        set_time_limit(0);

        $request = new Request($this->requestData);

        $bulkFulfillService = new BulkFulfillSalesOrdersService($request);

        $fulfillErrors = $bulkFulfillService->fulfill();

        $this->user->notifyNow(new FulfillSalesOrdersNotification(empty($fulfillErrors) ? null : json_encode($fulfillErrors)));
    }
}
