<?php

namespace App\Jobs;

use App\Services\FinancialManagement\SalesOrderLineFinancialManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CalculateSalesOrderLineFinancialsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(private readonly ?int $numLines = 1000)
    {
        $this->onQueue('financials');
    }

    public function handle(): void
    {
        app(SalesOrderLineFinancialManager::class)->calculate($this->numLines);
    }
}
