<?php

namespace App\Jobs;

use App\Actions\CacheDailyAverageConsumptionForProducts;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CacheDailyAverageConsumptionForProductsJob implements ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected array $productIds;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(array $productIds = [])
    {
        $this->onQueue('products');
        $this->productIds = $productIds;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        (new CacheDailyAverageConsumptionForProducts($this->productIds))->handle();
    }
}
