<?php

namespace App\Jobs;

use App\Helpers;
use App\Models\Supplier;
use App\Services\PurchaseOrder\PurchaseOrderManager;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Throwable;

class BackorderPurchasingJob implements ShouldQueue //, ShouldBeUnique
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    //protected int $uniqueFor = 60 * 30; // 30 minutes

    protected int $timeout = 60 * 15; // 15 minutes

    protected int $tries = 20; // 20 tries

    public int $backoff = 60;

    //    public function uniqueId(): string
    //    {
    //        return $this->supplier->id;
    //    }

    /**
     * ProcessBackorderPurchasing constructor.
     */
    public function __construct(private readonly Supplier $supplier)
    {
    }

    /**
     * Execute the job.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        // To attempt to prevent deadlocks, but it is not workign as expected, so going to comment out for now
        //        if (Helpers::isJobRunning(ReleaseBackorderQueuesJob::class))
        //        {
        //            Log::debug('ReleaseBackorderQueuesJob is running. Releasing back to queue with delay.');
        //            $this->release(10);
        //            return;
        //        }
        customlog('backorderPurchasing', "Backorder purchasing starting for supplier {$this->supplier->name} ({$this->supplier->id}), attempt ".$this->attempts().' of '.$this->tries, [], 7);
        (new PurchaseOrderManager($this->supplier))->processBackorderPurchasing();
        customlog('backorderPurchasing', "Backorder purchasing complete for supplier {$this->supplier->name} ({$this->supplier->id}), attempt ".$this->attempts().' of '.$this->tries, [], 7);
    }
}
