<?php

namespace App\Integrations;

use App\Models\ProductListing;
use App\Models\SalesOrder;
use Illuminate\Support\Collection;

/**
 * Interface SalesChannelOrder.
 * @deprecated use AbstractSalesChannelOrder instead
 */
interface SalesChannelOrder
{
    /**
     * We need to make sure that sales_channel_lines's sales_channel_line_id should be varchar.
     * This is required in mapping sales order lines other mapping will fail.
     *
     * Ex. shopify_order_line_items -> line_id
     * amazon_order_items -> OrderItemId
     */

    /**
     * @return mixed
     */
    public static function getResource();

    public function getSkuOrderLines(): array;

    /**
     * @param $sku
     * @return mixed
     */
    public function findMatchingLines(Collection $orderLines, ProductListing $productListing);

    /**
     * @return mixed
     */
    public function getSkuShippingMethodId();

    public function isFullyShipped(): bool;

    public function isPartiallyShipped(): bool;

    /**
     * @return mixed
     */
    public function partiallyFulfill(SalesOrder $salesOrder);

    public static function getOrderDateAttributeName(): string;
}
