<?php

namespace App\Integrations\Listings;

use App\Models\ProductListing;
use App\Models\TaskStatus\TaskStatus;
use Illuminate\Database\Eloquent\Builder;
use JetBrains\PhpStorm\ArrayShape;

/**
 * Interface ProductMapper.
 */
interface ProductMapper
{
    public function validationRules(): array;

    /**
     * @return mixed
     */
    #[ArrayShape(['mapped' => 'int', 'unmapped' => 'int', 'errors' => 'array'])]
    public function mapListings(array $mappings, ?TaskStatus $taskStatus = null);

    /**
     * @param  Builder|mixed  $builder
     * @return mixed
     */
    public function unmapListings(ProductListing $productListing);
}
