<?php

namespace App\Integrations\Listings;

use App\Models\Product;

/**
 * Class MagentoListingImporter.
 */
class MagentoListingImporter extends ListingImporter
{
    /**
     * @var string
     */
    protected $idColumn = 'variant_id';

    /**
     * @var string[]
     */
    protected $expectedColumns = [
        'variant_id',
        'mapped_sku',
    ];

    /**
     * @return mixed|void
     */
    protected function importRow(array $row)
    {
        if (! empty($row['mapped_sku'])) {
            $product = Product::with([])->where('sku', $row['mapped_sku'])->first();
            if ($product) {
                $row['product_id'] = $product->id;
            }
        }

        $this->mapper->mapListings([$row], $this->taskStatus);
    }
}
