<?php

namespace App\Importers\Parsers;

/**
 * Class TrimRight.
 */
class TrimRight extends Trim
{
    /**
     * @return false|mixed|string
     */
    public function parse($value)
    {
        return substr(
            $value,
            0,
            strlen($value) - $this->numOfChars
        );
    }

    public function parseSqlQuery(string $column, string $table): string
    {
        return "SUBSTR(`$table`.`$column`, 1, LENGTH(`$table`.`$column`) - {$this->numOfChars})";
    }
}
