<?php

namespace App\Importers\Parsers;

use Exception;

class Append implements FieldParser
{
    public $fieldName;

    public $separator;

    public function __construct(array $params, protected $model)
    {
        if (! array_key_exists('field_name', $params) || ! array_key_exists('separator', $params)) {
            throw new Exception('field_name and separator values must be provided.');
        }
        $this->fieldName = $params['field_name'];
        $this->separator = $params['separator'] ?? '';
    }

    public function parse($value)
    {
        return $value.$this->separator.$this->model->getValue($this->fieldName);
    }

    public function parseSqlQuery(string $column, string $table): string
    {
        $separator = str_replace("'", "\'", $this->separator);

        return "CONCAT(`$table`.`$column`, '$separator', `$table`.`{$this->fieldName}`)";
    }
}
