<?php

namespace App\Importers\DataImporters;

use App\DataTable\Exports\DataTableExporter as Exporter;
use App\Importers\DataImporter;

class SalesOrderLineFinancialDataImporter extends DataImporter
{
    public function __construct($taskId, string $filePath)
    {
        parent::__construct($taskId, $filePath);
    }

    public static function getExportableFields(): array
    {
        return [
            'id' => Exporter::makeExportableField('ID'),
            'description' => Exporter::makeExportableField('Description'),
            'sales_order.order_number' => Exporter::makeExportableField('Order #'),
            'order_date' => Exporter::makeExportableField('Date'),
            'product.sku' => Exporter::makeExportableField('SKU'),
            'customer.name' => Exporter::makeExportableField('Customer'),
            'quantity' => Exporter::makeExportableField('Qty'),
            'amount' => Exporter::makeExportableField('Unit Rev'),
            'revenue' => Exporter::makeExportableField('Rev'),
            'revenue_allocated' => Exporter::makeExportableField('Rev Alloc.'),
            'credits' => Exporter::makeExportableField('Credits'),
            'cogs' => Exporter::makeExportableField('COGS'),
            'cogs_returned' => Exporter::makeExportableField('COGS Returned'),
            'cost_allocated' => Exporter::makeExportableField('Cost Alloc.'),
            'total_cost' => Exporter::makeExportableField('Total Cost'),
            'profit' => Exporter::makeExportableField('Profit'),
            'profit_margin' => Exporter::makeExportableField('% Margin'),
            'brand_name' => Exporter::makeExportableField('Brand'),
            'supplier_name' => Exporter::makeExportableField('Supplier'),
            'store_name' => Exporter::makeExportableField('Store'),
            'integration_instance_name' => Exporter::makeExportableField('Sales Channel'),
            'created_at' => Exporter::makeExportableField('Created At'),
            'updated_at' => Exporter::makeExportableField('Updated At'),
        ];
    }

    protected function importRow(array $row)
    {
        // TODO: Implement importRow() method.
    }
}
