<?php

namespace App\Importers\DataImporters;

use App\DataTable\Exports\DataTableExporter as Exporter;
use App\Importers\DataImporter;

class SalesOrderFulfillmentDataImporter extends DataImporter
{
    public static function getExportableFields(): array
    {
        return [
            'id' => Exporter::makeExportableField('fulfillment_id'),
            'fulfillment_number' => Exporter::makeExportableField('fulfillment_number'),
            'fulfillment_sequence' => Exporter::makeExportableField('fulfillment_sequence'),
            'fulfillment_type' => Exporter::makeExportableField('fulfillment_type'),
            'warehouse.name' => Exporter::makeExportableField('warehouse'),
            'requested_shipping_method' => Exporter::makeExportableField('requested_shipping_method'),
            'fulfillment_shipping_method' => Exporter::makeExportableField('fulfillment_shipping_method'),
            'tracking_number' => Exporter::makeExportableField('tracking_number'),
            'tracking_link' => Exporter::makeExportableField('tracking_link'),
            'fulfilled_at' => Exporter::makeExportableField('fulfilled_at'),
            'packing_slip_printed_at' => Exporter::makeExportableField('packing_slip_printed_at'),
            'cost' => Exporter::makeExportableField('cost'),
            'created_at' => Exporter::makeExportableField('created_at'),
            'updated_at' => Exporter::makeExportableField('updated_at'),
            'archived_at' => Exporter::makeExportableField('archived_at'),
            'sales_order.sales_order_number' => Exporter::makeExportableField('sales_order_number'),
            'customer_reference' => Exporter::makeExportableField('customer_reference'),
            'store.name' => Exporter::makeExportableField('store_name'),
            'sales_channel_type_name' => Exporter::makeExportableField('sales_channel_type_name'),
            'sales_order_shipping_method' => Exporter::makeExportableField('sales_order_shipping_method'),
            'customer_name.name' => Exporter::makeExportableField('customer_name', true),
            'customer_email' => Exporter::makeExportableField('customer_email'),
            'customer_company' => Exporter::makeExportableField('customer_company'),
            'customer_phone' => Exporter::makeExportableField('customer_phone'),
            'customer_address' => Exporter::makeExportableField('customer_address', true, 'Customer Address Line 1'),
            'customer_city' => Exporter::makeExportableField('customer_city'),
            'customer_province' => Exporter::makeExportableField('customer_province'),
            'customer_province_code' => Exporter::makeExportableField('customer_province_code'),
            'customer_zip' => Exporter::makeExportableField('customer_zip'),
            'customer_country' => Exporter::makeExportableField('customer_country'),
            'customer_country_code' => Exporter::makeExportableField('customer_country_code'),
            'currency_code' => Exporter::makeExportableField('currency_code'),
            'fulfillment_line_id' => Exporter::makeExportableField('line_id'),
            'item_quantity' => Exporter::makeExportableField('item_quantity'),
            'item_sku.sku' => Exporter::makeExportableField('item_sku'),
            'item_price' => Exporter::makeExportableField('item_price'),
            'item_name' => Exporter::makeExportableField('item_name'),
            'item_nominal_code' => Exporter::makeExportableField('item_nominal_code'),
        ];
    }

    /**
     * {@inheritDoc}
     */
    protected function importRow(array $row)
    {
        // TODO: Implement importRow() method.
    }
}
