<?php

namespace App\Importers\DataImporters;

use App\DataTable\Exports\DataTableExporter as Exporter;
use App\Importers\DataImporter;

class SalesCreditDataImporter extends DataImporter
{
    protected function importRow(array $row)
    {
        // TODO: Implement importRow() method.
    }

    public static function getExportableFields(): array
    {
        return [
            'id' => Exporter::makeExportableField('id', true, 'ID'),
            'sales_credit_number' => Exporter::makeExportableField('sales_credit_number'),
            'sales_order.sales_order_number' => Exporter::makeExportableField('sales_order_number', false),
            'store.name' => Exporter::makeExportableField('store_name', false),
            'credit_date' => Exporter::makeExportableField('credit_date', false),
            'to_warehouse.name' => Exporter::makeExportableField('to_warehouse', true),
            'returns_receipt_date' => Exporter::makeExportableField('returns_receipt_date', false),
            'return_receipt_quantity' => Exporter::makeExportableField('return_receipt_quantity', false),
            'customer_name.name' => Exporter::makeExportableField('customer_name', true),
            'customer_email' => Exporter::makeExportableField('customer_email'),
            'customer_company' => Exporter::makeExportableField('customer_company'),
            'customer_phone' => Exporter::makeExportableField('customer_phone'),
            'customer_address' => Exporter::makeExportableField('customer_address', true, 'Customer Address Line 1'),
            'customer_city' => Exporter::makeExportableField('customer_city'),
            'customer_province' => Exporter::makeExportableField('customer_province'),
            'customer_province_code' => Exporter::makeExportableField('customer_province_code'),
            'customer_zip' => Exporter::makeExportableField('customer_zip'),
            'customer_country' => Exporter::makeExportableField('customer_country'),
            'customer_country_code' => Exporter::makeExportableField('customer_country_code'),
            'statuses.credit_status' => Exporter::makeExportableField('credit_status', false),
            'statuses.return_status' => Exporter::makeExportableField('return_status', false),
            'statuses.payment_status' => Exporter::makeExportableField('payment_status', false),
            'product_total' => Exporter::makeExportableField('product_total', false),
            'total' => Exporter::makeExportableField('total', false),
            'item_quantity' => Exporter::makeExportableField('item_quantity', true),
            'item_sku.sku' => Exporter::makeExportableField('item_sku', true),
            'item_price' => Exporter::makeExportableField('item_price', true),
            'item_cost' => Exporter::makeExportableField('item_cost', true),
            'item_name' => Exporter::makeExportableField('item_name', true),
            'item_nominal_code' => Exporter::makeExportableField('item_nominal_code', true),
            'item_discount' => Exporter::makeExportableField('item_discount', true),
            'item_tax' => Exporter::makeExportableField('item_tax', true),
            'item_img_url' => Exporter::makeExportableField('item_img_url', true),
            'is_product' => Exporter::makeExportableField('is_product', true),
            'has_products' => Exporter::makeExportableField('has_products', true),
            'is_received' => Exporter::makeExportableField('is_received', false),
            'created_at' => Exporter::makeExportableField('created_at', false),
            'updated_at' => Exporter::makeExportableField('updated_at', false),
        ];
    }
}
