<?php

namespace App\Importers\DataImporters;

use App\DataTable\Exports\DataTableExporter;
use App\Importers\DataImporter;
use App\Models\ProductBrand;
use App\Response;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

/**
 * Class ProductBrandDataImporter.
 */
class ProductBrandDataImporter extends DataImporter
{
    /**
     * @var string[]
     */
    protected $requiredColumns = [
        'name',
    ];

    /**
     * @return mixed|void
     */
    protected function importRow(array $row)
    {
        DB::transaction(function () use ($row) {
            // We create the given brand or update it if possible
            // We attempt to find by id or name
            if (! empty($row['id'])) {
                $brand = ProductBrand::with([])->find($row['id']);
                if (! $brand) {
                    $this->validationErrors[$row['name'] ?? $row['id']] = Response::getError(__('messages.import_export.id_not_exists', ['id' => $row['id']]), Response::CODE_NOT_FOUND, 'id', Arr::only($row, ['id', 'name']));
                    $this->taskStatus->addErrorMessage("Skipping id: The id {$row['id']} doesn't exist in SKU");

                    return;
                }
            } else {
                $brand = ProductBrand::with([])->where('name', $row['name'])->firstOrNew();
            }

            $brand->fill($row)->save();
        });
    }

    public static function getExportableFields(): array
    {
        return [
            'id' => DataTableExporter::makeExportableField('id', true, 'ID'),
            'name' => DataTableExporter::makeExportableField('name'),
        ];
    }
}
