<?php

namespace App\Importers\DataImporters;

use App\DataTable\Exports\DataTableExporter as Exporter;
use App\Importers\DataImporter;
use App\Models\AttributeGroup;
use App\Response;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

/**
 * Class AttributeGroupDataImporter.
 */
class AttributeGroupDataImporter extends DataImporter
{
    /**
     * @var string[]
     */
    protected $requiredColumns = [
        'name',
    ];

    /**
     * @return mixed|void
     */
    protected function importRow(array $row)
    {
        DB::transaction(function () use ($row) {
            // We create the given attribute group or update it if possible
            // We attempt to find by id or name
            if (! empty($row['id'])) {
                $group = AttributeGroup::with([])->find($row['id']);
                if (! $group) {
                    $this->validationErrors[$row['name'] ?? $row['id']] = Response::getError("ID {$row['id']} doesn't exist in SKU, review file and import again.", Response::CODE_NOT_FOUND, 'id', Arr::only($row, ['id', 'name']));
                    $this->taskStatus->addErrorMessage("Skipping id: The id {$row['id']} doesn't exist in SKU");

                    return;
                }
            } else {
                $group = AttributeGroup::with([])->where('name', $row['name'])->firstOrNew();
            }

            $group->fill($row)->save();
        });
    }

    public static function getExportableFields(): array
    {
        return [
            'id' => Exporter::makeExportableField('id', true, 'ID'),
            'name' => Exporter::makeExportableField('name'),
            'sort_order' => Exporter::makeExportableField('sort_order'),
        ];
    }
}
