<?php

namespace App\Http\Resources;

use App\Models\WarehouseTransferShipmentReceiptLine;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class WarehouseTransferReceiptLineResource.
 *
 * @mixin WarehouseTransferShipmentReceiptLine
 */
class WarehouseTransferReceiptLineResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'product_id' => $this->shipmentLine->warehouseTransferLine->product->id ?? null,
            'product_name' => $this->shipmentLine->warehouseTransferLine->product->name ?? null,
            'product_sku' => $this->shipmentLine->warehouseTransferLine->product->sku ?? null,
            'quantity' => $this->quantity,
            'units_pending' => $this->shipmentLine->quantity - $this->shipmentLine->total_received,
            'warehouse_transfer_line_id' => $this->shipmentLine->warehouse_transfer_line_id,
        ];
    }
}
