<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\Address;
use App\Models\Warehouse;
use Illuminate\Http\Request;

/**
 * Class WarehouseResource.
 *
 * @mixin Warehouse
 */
class WarehouseResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $defaultAddress = $this->address ?? new Address();

        return [
            'name' => $this->inclusive('name', $this->name),
            'id' => $this->id,
            'type' => $this->inclusive('type', $this->type),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('created_at', $this->updated_at),
            'archived_at' => $this->inclusive('created_at', $this->archived_at),
            'supplier' => $this->whenLoaded('supplier', function () {
                return [
                    'name' => $this->supplier->name,
                    'id' => $this->supplier->id,
                ];
            }),
            'address_name' => $this->inclusive('address_name', $defaultAddress->name),
            'order_fulfillment' => $this->inclusive('order_fulfillment', $this->order_fulfillment),
            'address_id' => $this->inclusive('address_id', $defaultAddress->id),
            'label' => $this->inclusive('label', $defaultAddress->label),
            'email' => $this->inclusive('email', $defaultAddress->email),
            'phone' => $this->inclusive('phone', $defaultAddress->phone),
            'fax' => $this->inclusive('fax', $defaultAddress->fax),
            'company' => $this->inclusive('company', $defaultAddress->company),
            'address1' => $this->inclusive('address1', $defaultAddress->address1),
            'address2' => $this->inclusive('address2', $defaultAddress->address2),
            'address3' => $this->inclusive('address3', $defaultAddress->address3),
            'city' => $this->inclusive('city', $defaultAddress->city),
            'province' => $this->inclusive('province', $defaultAddress->province),
            'province_code' => $this->inclusive('province_code', $defaultAddress->province_code),
            'zip' => $this->inclusive('zip', $defaultAddress->zip),
            'country' => $this->inclusive('country', $defaultAddress->country),
            'country_code' => $this->inclusive('country_code', $defaultAddress->country_code),
            'warehouse_locations' => $this->whenLoaded('warehouseLocations', function () {
                return $this->warehouseLocations;
            }),
            'shipping_automated' => Warehouse::getAutomatedWarehouses()[$this->id]['integration_name'] ?? null,
            'is_archivable' => $this->inclusive('is_archivable', $this->is_archivable),
            'auto_routing_enabled' => $this->inclusive('auto_routing_enabled', $this->auto_routing_enabled),
            'integration_instance_id' => $this->inclusive('integration_instance_id', $this->integration_instance_id),
            'nominal_code_id' => $this->inclusive('nominal_code_id', $this->nominal_code_id),
        ];
    }
}
