<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\TaxRate;
use Illuminate\Http\Request;

/** @mixin TaxRate */
class TaxRateResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray(Request $request): array
    {
        return [
            //-----------------------------------------------------
            // Basic Info
            //-----------------------------------------------------

            'id' => $this->id,
            'name' => $this->inclusive('name', $this->name),
            'rate' => $this->inclusive('rate', $this->rate),

            //-----------------------------------------------------
            // Timestamps
            //-----------------------------------------------------

            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),

            'tax_rate_lines' => $this->inclusive('tax_rate_lines', $this->whenLoaded('taxRateLines', function () {
                return $this->taxRateLines->map(function ($taxRateLine) {
                    return [
                        'id' => $taxRateLine->id,
                        'name' => $taxRateLine->name,
                        'rate' => $taxRateLine->rate,
                    ];
                })->toArray();
            })),
            'accounting_integration_id' => $this->accounting_integration_id,
        ];
    }
}
