<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;

class TagResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            //-----------------------------------------------------
            // Basic Info
            //-----------------------------------------------------

            'id' => $this->id,
            'name' => $this->inclusive('name', $this->name),

            //-----------------------------------------------------
            // Timestamps
            //-----------------------------------------------------

            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
        ];
    }
}
