<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;

class TableViewResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->inclusive('name', $this->name),
            'model' => $this->inclusive('model', $this->model),
            'is_favorite' => $this->inclusive('is_favorite', $this->is_favorite),
            'is_default' => $this->inclusive('is_default', $this->is_default),
            'content' => $this->inclusive('content', $this->content),
        ];
    }
}
