<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\SupplierInventory;
use Illuminate\Http\Request;

/**
 * Class SupplierInventoryResource.
 *
 *
 * @mixin SupplierInventory
 */
class SupplierInventoryResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'quantity' => $this->inclusive('quantity', $this->quantity),
            'in_stock' => $this->inclusive('in_stock', $this->in_stock),
            'discontinued' => $this->inclusive('discontinued', $this->discontinued),
            'eta' => $this->inclusive('eta', $this->eta),
            'source' => $this->inclusive('source', $this->source),
            'sku' => $this->whenLoaded('product', function () {
                return $this->product->sku;
            }),
            'product_name' => $this->whenLoaded('product', function () {
                return $this->product->name;
            }),
            'warehouse' => $this->whenLoaded('warehouse', function () {
                return [
                    'id' => $this->warehouse->id,
                    'name' => $this->warehouse->name,
                ];
            }),
            'supplier_sku' => $this->inclusive('supplier_sku', $this->supplier_sku),
            'supplier_id' => $this->inclusive('supplier_id', $this->supplier_id),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
        ];
    }
}
