<?php

namespace App\Http\Resources\Shopify;

use App\DataTable\DataTableResource;
use App\Models\Shopify\ShopifyShippingService;
use Illuminate\Http\Request;

/**
 * Class AmazonShippingServiceResource.
 *
 *
 * @mixin ShopifyShippingService
 */
class ShopifyShippingServiceResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->_id,
            'name' => $this->name,
            'code' => $this->code,
            'active' => $this->active,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'domestic' => $this->domestic,
            // mapped shipping method
            'shipping_method_id' => $this->integration_shipping_method->shipping_method_id ?? null,
        ];
    }
}
