<?php

namespace App\Http\Resources\Shopify;

use App\DataTable\DataTableResource;
use App\Models\Shopify\ShopifyProduct;

/**
 * Class ProductResource.
 *
 * @mixin \App\Models\Shopify\ShopifyProduct
 */
class ShopifyProductResource extends DataTableResource
{
    public function toArray($request): array
    {
        $result = [
            'id' => $this->id,
            'product_listing_id' => $this->inclusive('product_listing_id', $this->productListing ? $this->productListing->id : null),
            'variant_id' => $this->inclusive('variant_id', $this['variant_id']),
            'sku' => $this->inclusive('sku', $this['sku']),
            'image' => $this->inclusive('image', $this['image'] ?? (count($this['images'] ?? []) ? $this['images'][0] : null)),
            'price' => $this->inclusive('price', $this['price']),
            'variant_title' => $this->inclusive('variant_title', $this['variant_title']),
            'product_title' => $this->inclusive('product_title', $this['product_title']),
            'barcode' => $this->inclusive('barcode', $this['barcode']),
            'unit_cost' => $this->inclusive('unit_cost', $this['unit_cost']),
            'body_html' => $this->inclusive('body_html', $this['body_html']),
            'inventory_quantity' => $this->inclusive('inventory_quantity', $this['inventory_quantity']),
            'product' => $this->inclusive('product', ($this->productListing ? $this->productListing?->product->only('id', 'name', 'sku') : null)),
            'product_id' => $this->inclusive('product_id', $this['product_id']),
            'handle' => $this->inclusive('handle', $this['handle']),
            'published_scope' => $this->inclusive('published_scope', $this['published_scope']),
            'vendor' => $this->inclusive('vendor', $this['vendor']),
            'product_type' => $this->inclusive('product_type', $this->productListing?->product?->type),
            'options' => $this->json_object['options'] ?? [],
            'images' => $this->inclusive('images', $this['images']),
            'mapped_sku' => $this->inclusive('mapped_sku', $this->productListing ? $this->productListing->product->sku : null),
            'removed_from_shopify' => $this->inclusive('removed_from_shopify', $this['removed_from_shopify']),
            'status' => $this->inclusive('status', $this['status']),
            'created_at' => $this->inclusive('created_at', $this['created_at']),
            'updated_at' => $this->inclusive('updated_at', $this['updated_at']),
            'published_at' => $this->inclusive('published_at', $this['published_at']),
            'mapped_at' => $this->inclusive('mapped_at', $this['mapped_at']),
        ];

        foreach ($result['options'] as $option) {
            $result['options.'.strtolower($option['name'])] = $this->json_object["option{$option['position']}"];
        }

        return $result + $this->getRequestedImages();
    }

    protected function getRequestedImages(): array
    {
        $withMostImages = ShopifyProduct::getWithMostImages();

        if (! $withMostImages) {
            return [];
        }
        $images = [];
        for ($i = 0; $i < $withMostImages->image_count; $i++) {
            $row = $i + 1;
            $field = 'image'.$row;
            $value = isset($this['images']) && isset($this['images'][$i]) ? $this['images'][$i]['src'] : null;
            $images[$field] = $this->inclusive($field, $value);
        }

        return $images;
    }
}
