<?php

namespace App\Http\Resources\Shopify;

use App\Abstractions\Integrations\SalesChannels\ProductListingResourceInterface;
use App\DataTable\DataTableResource;
use App\Models\ProductListing;
use Illuminate\Http\Request;
use Spatie\LaravelData\Optional;

/**
 * Class ProductListingResource.
 *
 * @mixin ProductListing
 */
class ShopifyProductListingResource extends DataTableResource implements ProductListingResourceInterface
{
    /**
     * @param  Request  $request
     * @return array
     */
    public function toArray(Request $request): array
    {

        $inventoryData = $this->getInventoryRulesData();

        return [
            'id' => $this->id,
            'listing_sku' => [
                'sku' => $this->listing_sku,
                'id' => $this->id,
                'url' => ($this->document ? $this->document->getListingUrl() : null),
            ],
            'sales_channel_listing_id' => $this->sales_channel_listing_id,
            'title' => $this->title,
            'sales_channel' => $this->salesChannel->name,
            'integration_instance_id' => $this->salesChannel->integration_instance_id,
            'integration' => $this->salesChannel->integration->only(['id', 'name']),
            'price_inherit' => empty($this->master_of_price),
            'price' => $this->price,
            'master_of_price' => $this->active_master_of_price,
            'pricing_tier_id' => $this->active_pricing_tier_id,
            'pricing_tier' => in_array(
                $this->active_master_of_price,
                [ProductListing::MASTER_SKU, ProductListing::MASTER_SALES_CHANNEL]
            ) ?
                ($this->productPricingTier->name ?? $this->general_pricing_tier['name']) :
                null,
            'stock_inherit' => empty($this->master_of_stock),
            'quantity' => $this->quantity,
            'master_of_stock' => $this->active_master_of_stock,
            'sales_channel_settings' => $this->inclusive('sales_channel_settings', $this->sales_channel_settings),
            'fulfillment_latency' => $this->active_fulfillment_latency,
            'inventory_rules' => $this->inclusive('inventory_rules', $this->inventory_rules),
            'archived_at' => $this->archived_at,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
