<?php

namespace App\Http\Resources\Shopify;

use App\DataTable\DataTableResource;
use App\Models\Shopify\ShopifyOrder;
use Illuminate\Http\Request;

/**
 * Class OrderResource.
 *
 * @mixin ShopifyOrder
 */
class ShopifyOrderResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'order_number' => $this->inclusive('order_number', $this->order_number),
            'name' => $this->inclusive('name', $this->name),
            'financial_status' => $this->inclusive('financial_status', $this->financial_status),
            'fulfillment_status' => $this->inclusive('fulfillment_status', $this->fulfillment_status),
            'customer_name' => $this->inclusive('customer_name', $this->customer_name),
            'email' => $this->inclusive('email', $this->email),
            'total_price' => $this->inclusive('total_price', $this->total_price),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'archived_at' => $this->archived_at,
        ];
    }
}
