<?php

namespace App\Http\Resources\Shopify;

use App\Models\Shopify\ShopifyProduct;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class SalesOrderLineListingShopifyResource.
 *
 * @mixin array
 */
class SalesOrderLineListingShopifyResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this['id'],
            'product_id' => @$this['product']->id ?? null,
            'unique_sales_channel_product_id' => $this['variant_id'],
            'skuAlias' => $this['sku'],
            'sku' => $this['sku'],
            'title' => $this['title'],
            'handle' => @$this['product']->handle ?? null,
            'shop_url' => @$this['product']?->integrationInstance->connection_settings['shop_url'] ?? null,
            'quantity' => $this['quantity'],
            'amount' => $this['price'] - (collect($this['discount_allocations'])->sum('amount') / $this['quantity']),
            'tax_allocation' => collect($this['tax_lines'])->sum('price'),
        ];
    }
}
