<?php

namespace App\Http\Resources;

use App\Models\ShipStation\ShipstationWarehouse;
use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use JsonSerializable;

/**
 * @mixin ShipstationWarehouse
 */
class ShipstationWarehouseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array|Arrayable|JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'shipstation_id' => $this->shipstation_id,
            'name' => $this->name,
            'is_default' => $this->is_default,
            'json_object' => $this->json_object,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
