<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;

class ShippingMethodResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'method_name' => $this->inclusive('method_name', $this->name),
            'full_name' => $this->inclusive('method_name',
                ! empty($this->full_name) ? $this->full_name : ($this->shippingCarrier->name ?? '').' '.$this->name),
            'carrier_id' => $this->shipping_carrier_id,
            'carrier_name' => $this->inclusive('carrier_name', $this->when($this->resource->relationLoaded('shippingCarrier'), function () {
                return $this->shippingCarrier->name;
            })),
            'min_business_days' => $this->inclusive('min_business_days', $this->delivery_min),
            'max_business_days' => $this->inclusive('max_business_days', $this->delivery_max),
            'included_locations' => $this->inclusive('included_locations', $this->included_locations),
            'excluded_locations' => $this->inclusive('excluded_locations', $this->excluded_locations),
            'type' => $this->inclusive('type', $this->type),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
        ];
    }
}
