<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\ShippingMethodMappingsSkuToShippingProviderMethod;
use Illuminate\Http\Request;

/**
 * @mixin ShippingMethodMappingsSkuToShippingProviderMethod
 */
class ShippingMethodMappingShippingProviderResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'shipping_provider_id' => $this->shipping_provider_id,
            'shipping_provider_carrier' => $this->shipping_provider_carrier,
            'shipping_provider_method' => $this->shipping_provider_method,
            'shipping_method_id' => $this->shipping_method_id,
            'shipping_method_name' => $this->shippingMethod->name ?? null,
        ];
    }
}
