<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\ShipBySchedule;
use Illuminate\Http\Request;

/**
 * @mixin ShipBySchedule
 */
class ShipByScheduleResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'ship_by_date' => $this->ship_by_date,
            'product_id' => $this->product_id,
            'product_sku' => $this->product_sku,
            'product_name' => $this->product_name,
            'total_quantity' => $this->total_quantity,
            'shortage_quantity' => $this->shortage_quantity,
            'covered_quantity' => $this->covered_quantity,
            'uncovered_quantity' => $this->uncovered_quantity,
            'total_orders' => $this->total_orders,
        ];
    }
}
