<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\SalesOrderLineFinancial;
use Illuminate\Http\Request;

/**
 * Class SalesOrderLineFinancialsResource.
 *
 * @mixin SalesOrderLineFinancial
 *
 * @property float $total_revenue
 * @property float $total_cost
 * @property float $total_profit
 */
class SalesOrderLineFinancialResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     */
    public function toArray($request): array
    {
        $this->load(['salesOrderLine.salesOrder.salesChannel.integrationInstance.integration',
            'salesOrderLine.salesOrder.salesChannel.store',
            'salesOrderLine.warehouse.supplier',
            'salesOrderLine.product.brand',
        ]);

        return [
            'id' => $this->id,
            'sales_order_line_id' => $this->sales_order_line_id,
            'sales_order' => $this->inclusive('sales_order', [
                'id' => $this->salesOrderLine->salesOrder->id ?? null,
                'order_number' => $this->salesOrderLine->salesOrder->sales_order_number ?? null,
            ]),
            'description' => $this->inclusive('description', $this->salesOrderLine->description ?? null),
            'product' => $this->inclusive('product', [
                'id' => $this->salesOrderLine->product?->id ?? null,
                'sku' => $this->salesOrderLine->product?->sku ?? null,
            ]),
            'sku'               => $this->inclusive('product', $this->salesOrderLine->product?->sku ?? null),
            'brand_name' => $this->inclusive('brand_name', $this->salesOrderLine->product?->brand?->name ?? null),
            'store_name' => $this->inclusive('store_name', $this->salesOrderLine->salesOrder->salesChannel->store->name ?? null),
            'integration_name' => $this->inclusive('integration_name', $this->salesOrderLine->salesOrder->salesChannel->integrationInstance->integration->name ?? null),
            'integration_instance_name' => $this->inclusive('integration_instance_name', $this->salesOrderLine->salesOrder->salesChannel->integrationInstance->name ?? null),
            'supplier_name' => $this->inclusive('supplier_name', $this->salesOrderLine->product?->defaultSupplierProduct?->supplier->name ?? null),
            'order_date'        => $this->inclusive('order_date', $this->salesOrderLine->salesOrder->order_date ?? null),
            'order_status'      => $this->inclusive('order_status', $this->salesOrderLine->salesOrder->status ?? null),
            'fulfillment_status' => $this->inclusive('fulfillment_status', $this->salesOrderLine->salesOrder->fulfillment_status ?? null),
            'customer'          => $this->inclusive('customer', [
                'id'   => $this->salesOrderLine->salesOrder->customer_id ?? null,
                'name' => $this->salesOrderLine->salesOrder->customer->name ?? '',
            ]),
            'quantity' => $this->inclusive('quantity', $this->salesOrderLine->quantity ?? null),
            'amount' => $this->inclusive('amount', $this->salesOrderLine->amount_in_tenant_currency ?? null),
            'revenue' => $this->inclusive('revenue', $this->revenue),
            'revenue_allocated' => $this->inclusive('revenue', $this->revenue_allocated),
            'credits' => $this->inclusive('credits', $this->credits),
            'cogs' => $this->inclusive('cogs', $this->cogs),
            'cogs_returned' => $this->inclusive('cogs_returned', $this->cogs_returned),
            'cost_allocated' => $this->inclusive('cost_allocated', $this->cost_allocated),
            'total_cost' => $this->inclusive('total_cost', $this->total_cost),
            'profit' => $this->inclusive('profit', $this->profit),
            'profit_margin' => $this->inclusive('profit_margin', $this->profit_margin),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
        ];
    }
}
