<?php

namespace App\Http\Resources;

use App\Models\BackorderQueueCoverage;
use App\Models\BackorderQueueRelease;
use App\Models\SalesOrderLine;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin SalesOrderLine */
class SalesOrderLineDetailResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'next_scheduled_po' => $this->backorderQueue?->getSchedule(),
            'active_coverages' => $this->whenLoaded('backorderQueue', function () {
                return $this->backorderQueue->backorderQueueCoverages()->active()->get()->map(function (BackorderQueueCoverage $backorderQueueCoverage) {
                    return [
                        'purchase_order_id' => $backorderQueueCoverage->purchaseOrderLine->purchase_order_id,
                        'purchase_order_number' => $backorderQueueCoverage->purchaseOrderLine->purchaseOrder->purchase_order_number,
                        'quantity' => $backorderQueueCoverage->unreleased_quantity,
                        'date' => $backorderQueueCoverage->purchaseOrderLine->purchaseOrder->purchase_order_date,
                        'eta' => $backorderQueueCoverage->purchaseOrderLine->purchaseOrder->estimated_delivery_date,
                    ];
                });
            }),
            'releases' => $this->whenLoaded('backorderQueue', function () {
                return $this->backorderQueue->backorderQueueReleases->map(function (BackorderQueueRelease $backorderQueueRelease) {
                    return [
                        'id' => $backorderQueueRelease->id,
                        'link' => [
                            'id' => $backorderQueueRelease->link->getDrawer()->id,
                            'type' => get_class($backorderQueueRelease->link),
                            'parent_type' => get_class($backorderQueueRelease->link->getDrawer()),
                        ],
                        'reference' => $backorderQueueRelease->reference,
                        'quantity' => $backorderQueueRelease->released_quantity,
                        'release_date' => $backorderQueueRelease->link->created_at,
                    ];
                });
            }),
        ];
    }
}
